from django.http import HttpResponse, HttpResponseBadRequest

from staff.lib.decorators import responding_json
from staff.lib.models.mptt import filter_by_heirarchy

from staff.vcard.vcard_generator import _get_vcards

MAX_EMAILS_COUNT = 100


def _get_persons_qs(filter_context, url):
    persons_qs = filter_context.get_person_obj_qs()

    if url:
        dep = filter_context.get_base_dep_qs().get(url=url)
        persons_qs = filter_by_heirarchy(
            persons_qs,
            mptt_objects=[dep],
            by_children=True,
            include_self=True,
            filter_prefix='department__',
        )

    return persons_qs


def get_vcards(filter_context, include_contacts: bool, url):
    persons_qs = _get_persons_qs(filter_context, url)
    vcard_stream = _get_vcards(persons_qs, include_contacts, extend=True, ignore_photo=True)
    response = HttpResponse(vcard_stream, content_type='text/x-vcard')
    response['Content-Disposition'] = 'attachment; filename=%s.vcf' % url
    return response


@responding_json
def _get_emails(persons_qs):
    if persons_qs.count() > MAX_EMAILS_COUNT:
        return HttpResponseBadRequest('address limit exceeded')
    return list(persons_qs.values_list('work_email', flat=True))


def get_mailto(filter_context, url):
    persons_qs = _get_persons_qs(filter_context, url)
    return _get_emails(persons_qs)
