from django.db.models.query import QuerySet
from typing import Sequence, Dict


class AbstractEntityInfo(object):
    """
    Base class for info getters to work with DepartmentFiller
    Responsible for providing info about entities linked to departments
    Methods called in order: fill_counters, fill_info, filter_result
    Method filter called separately from main process
    """
    value_stream_field_name = 'valuestream'

    def __init__(self, filter_context):
        self.filter_context = filter_context

    def fill_counters(self, all_ids: Sequence, departments: Sequence):
        raise NotImplementedError

    def fill_info(self, all_ids: Sequence, departments: Sequence, info_map: Dict) -> Sequence:
        raise NotImplementedError

    def fill_dep_attrs(self, all_ids: Sequence, departments: Sequence) -> Sequence:
        raise NotImplementedError

    def filter_result(self, departments: Sequence) -> Sequence:
        raise NotImplementedError

    def filter(self, all_ids: Sequence, departments: Sequence):
        raise NotImplementedError

    def order_entities_by_fields(self) -> list:
        raise NotImplementedError

    def fill_list(self, entities: QuerySet) -> Sequence:
        raise NotImplementedError

    def departments_query(self) -> QuerySet:
        raise NotImplementedError

    def entities_quantity_by_department_query(self, entity_dep_field_name: str) -> QuerySet:
        raise NotImplementedError

    def total_entities_count_query(self) -> QuerySet:
        raise NotImplementedError

    def total_entities_aggregate_query(self, fields) -> QuerySet:
        raise NotImplementedError

    def short_entities_query(self) -> QuerySet:
        raise NotImplementedError

    def full_entities_query(self) -> QuerySet:
        raise NotImplementedError
