from django.conf.urls import url, include

from staff.headcounts import views as headcount_views

from staff.departments.orgsoffices import views as orgsoffices_views
from staff.departments.tree import views as tree_views


urlpatterns = [
    url(r'^tree/?$', tree_views.tree, name='tree'),
    url(r'^tree/(?P<url>\w+)/?$', tree_views.tree, name='tree-url'),
    url(r'^tree/(?P<url>\w+)/descendants/?$', tree_views.tree_descendants, name='tree-descendants'),
    url(r'^tree/(?P<url>\w+)/info/?$', tree_views.tree_info, name='tree-info'),
    url(r'^tree/(?P<url>\w+)/expand/?$', tree_views.tree_expand, name='tree-expand'),

    url(r'^sections/?$', tree_views.tree_sections, name='tree-sections'),

    url(r'^persons/?$', tree_views.persons, name='persons'),
    url(r'^persons/(?P<url>\w+)/?$', tree_views.persons, name='persons-url'),

    url(r'export_attendance/?$', tree_views.export_attendance, name='export-attendance'),

    url(r'^vcards/?$', tree_views.vcards, name='vcards'),
    url(r'^vcards/(?P<url>\w+)/?$', tree_views.vcards, name='vcards-url'),
    url(r'^export/meta/?$', tree_views.export_meta, name='export-meta'),
    url(r'^export/?$', tree_views.export, name='export'),
    url(r'^export/(?P<url>\w+)/?$', tree_views.export, name='export-url'),

    url(r'^mailto/?$', tree_views.mailto, name='mailto'),
    url(r'^mailto/(?P<url>\w+)/?$', tree_views.mailto, name='mailto-url'),

    url(r'^short_edit/(?P<url>\w+)/?$', tree_views.short_edit, name='short_edit'),
    url(r'^value_streams/?$', tree_views.value_streams, name='value-streams'),

    url(
        r'^admin/',
        include('staff.departments.edit.admin.urls', namespace='proposals-admin'),
    ),

    url(
        r'^edit/',
        include('staff.departments.edit.urls', namespace='edit-departments'),
    ),

    url(r'^ancestors/(?P<url>\w+)/?$', tree_views.ancestors, name='ancestors'),

    url(r'^ceilings/?$', headcount_views.old_ceilings, name='ceilings'),
    url(r'^ceilings/(?P<url>\w+)/?$', headcount_views.old_ceilings, name='ceilings-url'),
    url(
        r'^budget_position_assignments/?$',
        headcount_views.budget_position_assignments,
        name='budget_position_assignments',
    ),
    url(
        r'^budget_position_assignments/(?P<url>\w+)/?$',
        headcount_views.budget_position_assignments,
        name='budget_position_assignments_url',
    ),
    url(r'^ceilings/summary/(?P<login>[\w\-\_\.]+)/?$', headcount_views.headcounts_summary, name='headcounts-summary'),
    url(
        r'^ceilings/summary/department/(?P<url>\w+)/?$',
        headcount_views.headcounts_summary_for_department,
        name='headcounts-summary-by-departments',
    ),

    url(r'^hc_export/(?P<department_id>\d+)/$', headcount_views.headcounts_export_views.hc_export, name='hc_export'),

    url(
        r'^flexible-ceilings-export/(?P<url>\w+)/?$',
        headcount_views.flexible_ceilings_export,
        name='flexible_ceilings_export',
    ),

    url(r'^orgsoffices/?$', orgsoffices_views.orgsoffices, name='orgsoffices'),
]
