from staff.departments.models import Department


def get_last_position(parent):
    if parent is None:
        return 0

    try:
        last_position = parent.get_descendants().order_by('-lft')[0].position
    except IndexError:
        last_position = parent.position

    return last_position


def get_department_path(department, include_self=True):
    if department is None:
        return ''

    dep_ids = [str(d) for d in
               department.get_ancestors(include_self=include_self)
               .values_list('id', flat=True).order_by('level')]
    return '/'.join(dep_ids)


def get_department_chain(tree_id, lft, rght, fields_list=('name', 'name_en', 'kind_id', 'id', 'url'), **kwargs):
    return (
        Department.all_types
        .filter(tree_id=tree_id, lft__lte=lft, rght__gte=rght)
        .values(*fields_list)
        .order_by('lft')
    )
