from django.contrib import admin
from .models import Log


class LogAdmin(admin.ModelAdmin):
    list_display = (
        'model_name',
        'primary_key',
        'action',
        'modified_at',
    )
    list_filter = 'model_name', 'action'
    search_fields = 'data',
    ordering = '-modified_at',


admin.site.register(Log, LogAdmin)
