# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Log',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('model_name', models.CharField(max_length=50, db_index=True)),
                ('primary_key', models.IntegerField(db_index=True)),
                ('action', models.CharField(max_length=1, choices=[('c', 'create'), ('s', 'update'), ('d', 'delete')])),
                ('data', models.TextField()),
                ('modified_at', models.DateTimeField(db_index=True, auto_now=True)),
                ('modified_precise', models.CharField(verbose_name='Точное время', max_length=26, db_index=True, help_text='Датавремя в ISO 8601 с микроосекундами. Пример: 2012-12-07T13:00:36.706130')),
            ],
            options={
                'db_table': 'babylon_log',
            },
        ),
        migrations.AlterUniqueTogether(
            name='log',
            unique_together=set([('model_name', 'primary_key', 'action')]),
        ),
    ]
