from django import forms

from staff.lib.forms.fields import StaffField

from staff.dismissal.models import Dismissal, MaillistDuty, CheckPoint

jquery_url = '//js.static.yandex.net/jquery/1.3.2/_jquery.js'


# django admin forms
class DismissalAdminForm(forms.ModelForm):
    staff = StaffField(label='Увольняемый сотрудник')
    forward_correspondence_to = StaffField(required=False,
                                           label='Перенаправлять почту')
    give_correspondence_to = StaffField(required=False,
                                        label='Архивировать и передать')
    give_files_to = StaffField(required=False, label='Передать файлы')
    created_by = StaffField(label='Кто создал')
    completed_by = StaffField(label='Кто уволил')

    class Meta:
        fields = '__all__'
        model = Dismissal

    class Media:
        js = (jquery_url,)


class MaillistDutyAdminForm(forms.ModelForm):
    responsible = StaffField(label='Ответственный за рассылку', required=False)

    class Meta:
        fields = '__all__'
        model = MaillistDuty

    class Media:
        js = (jquery_url,)


class CheckPointAdminForm(forms.ModelForm):
    checked_by = StaffField(label='Отметил', required=False)

    class Meta:
        fields = '__all__'
        model = CheckPoint
#        exclude = ('name_en', 'description_en')

    class Media:
        js = (jquery_url,)
