from django import forms

from staff.lib.validators import validate_login
from staff.dismissal.models import CheckPoint, Dismissal


def validate_checkpoint_id(value):
    if not CheckPoint.objects.filter(pk=value).exists():
        raise forms.ValidationError('Нет пункта с id %d' % value)


def validate_dismissal_id(value):
    if not Dismissal.objects.filter(pk=value).exists():
        raise forms.ValidationError('Нет заявки с id %d' % value)


class ChitTplForm(forms.Form):
    login = forms.CharField(
        label='Логин сотрудника', help_text='Логин', validators=[validate_login]
    )


class CheckpointPermsForm(forms.Form):
    login = forms.CharField(
        label='Логин сотрудника',
        help_text='Логин',
        validators=[validate_login]
    )
    checkpoint_id = forms.IntegerField(
        required=False,
        label='id пункта обходного', help_text='id пункта обходного',
        validators=[validate_checkpoint_id]
    )


class DismissalPermsForm(forms.Form):
    login = forms.CharField(label='Логин сотрудника', validators=[validate_login])
    dismissal_id = forms.IntegerField(required=False, label='id заявки', validators=[validate_dismissal_id])


class DismissalCreatingPermsForm(forms.Form):
    who_login = forms.CharField(label='Кто', validators=[validate_login])
    for_whom_login = forms.CharField(label='Для кого', validators=[validate_login])
