from django.dispatch import receiver
from staff.audit.factory import create_log

from staff.dismissal.signals import dismissal_completed, dismissal_cancelled


@receiver(dismissal_completed)
def handle_dismissal_complete(author, staff, **kw):
    """Сохраняет в лог уволенного сотрудника"""
    create_log(
        objects=[staff],
        who=author.user,
        action='staff_dismissed',
        primary_key=staff.pk
    )


@receiver(dismissal_cancelled)
def handle_dismissal_cancel(dismissal, cancelled_by, **kw):
    """Сохраняет в лог отмену увольнения"""

    create_log(
        objects=[dismissal],
        who=cancelled_by.user,
        action='dismissal_cancelled',
        primary_key=dismissal.pk
    )
