from django.db.models.query_utils import Q

from staff.security.managers import AvailableObjectsManager


class DismissalManager(AvailableObjectsManager):

    @staticmethod
    def handle_checkpoints_responsibility(staff):
        """
        Метод возвращает условие фильтрации заявок, на основе ответственности за
        пункт в обходном этой заявки
        """
        return Q(checkpoints__template__responsibles=staff)
