# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CheckPoint',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('name', models.CharField(verbose_name='dismissal.checkpoint_name-label', max_length=255, blank=True)),
                ('name_en', models.CharField(verbose_name='dismissal.checkpoint_name_en-label', max_length=255, blank=True)),
                ('description', models.TextField(verbose_name='dismissal.checkpoint_description_en-label', blank=True)),
                ('description_en', models.TextField(verbose_name='dismissal.checkpoint_description_en-label', blank=True)),
                ('position', models.PositiveSmallIntegerField(verbose_name='dismissal.checkpoint_position-label', default=1)),
                ('checked', models.BooleanField(verbose_name='dismissal.checkpoint_checked-label', default=False)),
                ('checked_at', models.DateTimeField(verbose_name='dismissal.checkpoint_checked_at-label', blank=True, null=True)),
            ],
            options={
                'verbose_name': 'dismissal.checkpoint',
                'verbose_name_plural': 'dismissal.checkpoint_plural',
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='CheckPointTemplate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('name', models.CharField(verbose_name='dismissal.checkpoint_name-label', max_length=255, blank=True)),
                ('name_en', models.CharField(verbose_name='dismissal.checkpoint_name_en-label', max_length=255, blank=True)),
                ('description', models.TextField(verbose_name='dismissal.checkpoint_description-label', blank=True)),
                ('description_en', models.TextField(verbose_name='dismissal.checkpoint_description_en-label', blank=True)),
                ('position', models.PositiveSmallIntegerField(verbose_name='dismissal.checkpoint_position-label', default=1)),
            ],
            options={
                'verbose_name': 'dismissal.checkpoint_template',
                'verbose_name_plural': 'dismissal.checkpoint_template_plural',
            },
        ),
        migrations.CreateModel(
            name='ClearanceChitTemplate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
            ],
            options={
                'verbose_name': 'dismissal.chit_template-label',
                'verbose_name_plural': 'dismissal.chit_template_plural-label',
            },
        ),
        migrations.CreateModel(
            name='Dismissal',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('status', models.CharField(verbose_name='dismissal.status-label', max_length=1, default='N', choices=[('N', 'dismissal.status.new-option'), ('I', 'dismissal.status.in_progress-option'), ('X', 'dismissal.status.cancelled-option'), ('P', 'dismissal.status.date_passed-option'), ('C', 'dismissal.status.chit_not_complete-option'), ('D', 'dismissal.status.done-option')])),
                ('quit_date', models.DateField(verbose_name='dismissal.quit_date-label', null=True)),
                ('deadline', models.DateField(verbose_name='Крайний срок увольнения', null=True, default=None)),
                ('note', models.TextField(verbose_name='dismissal.note-label', blank=True)),
                ('delete_email_address', models.BooleanField(verbose_name='dismissal.delete_email_address-label', default=False)),
                ('delete_correspondence', models.BooleanField(verbose_name='dismissal.delete_correspondence-label', default=False)),
                ('delete_files', models.BooleanField(verbose_name='dismissal.delete_files-label', default=False)),
                ('keep_files', models.BooleanField(verbose_name='dismissal.keep_files-label', default=False)),
                ('move_to_ext', models.BooleanField(verbose_name='Сделать внешним', default=False)),
                ('move_to_ext_issue', models.CharField(verbose_name='Тикет перевода во внешние', max_length=512, default='')),
                ('quit_datetime_real', models.DateTimeField(verbose_name='dismissal.quit_datetime_real-label', blank=True, null=True)),
                ('initiator', models.CharField(verbose_name='dismissal.initiator-label', max_length=16, default='', choices=[('employee', 'dismissal.initiator.employee'), ('company', 'dismissal.initiator.company'), ('contract', 'dismissal.initiator.contract'), ('other', 'dismissal.initiator.other')])),
                ('need_hr_help', models.BooleanField(verbose_name='dismissal.need_hr_help-label', default=False)),
                ('reason', models.CharField(verbose_name='dismissal.reason-label', max_length=512, blank=True, default='')),
                ('new_employer', models.CharField(verbose_name='dismissal.new_employer-label', max_length=512, blank=True, default='')),
                ('impression', models.CharField(verbose_name='dismissal.impression-label', max_length=16, default='', choices=[('good', 'dismissal.impression.good'), ('neutral', 'dismissal.impression.neutral'), ('evil', 'dismissal.impression.evil')])),
                ('delete_from_search', models.CharField(verbose_name='dismissal.delete_from_search-label', max_length=16, blank=True, default='', choices=[('immediately', 'dismissal.delete_from_search.immediately'), ('after_2_weeks', 'dismissal.delete_from_search.after_2_weeks')])),
                ('comment', models.CharField(verbose_name='dismissal.comment-label', max_length=512, blank=True, default='')),
                ('created_at', models.DateTimeField(verbose_name='dismissal.created_at-label', auto_now_add=True)),
                ('modified_at', models.DateTimeField(verbose_name='dismissal.modified_at-label', auto_now=True)),
                ('rehire_recommendation', models.CharField(verbose_name='dismissal.rehire-label', max_length=32, default='', choices=[('highly_recommend', 'dismissal.rehire_recommendation.highly_recommend'), ('recommend', 'dismissal.rehire_recommendation.recommend'), ('not_my_team', 'dismissal.rehire_recommendation.not_my_team'), ('no', 'dismissal.rehire_recommendation.no')])),
            ],
            options={
                'verbose_name': 'dismissal.dismissal_request',
                'verbose_name_plural': 'dismissal.dismissal_request_plural',
                'permissions': (('can_dismiss_from_anketa', 'Can dismiss employees from anketa'), ('can_dismiss_from_chit', 'Can dismiss employees from chit'), ('can_create_dismissal', 'Can create dismissal requests'), ('can_update_dismissal', 'Can update dismissal requests'), ('can_cancel_dismissal', 'Can cancel dismissal requests'), ('can_see_hr_note', 'Can see hr note')),
            },
        ),
        migrations.CreateModel(
            name='MaillistDuty',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('maillist', models.CharField(verbose_name='dismissal.maillist-label', max_length=255)),
                ('dismissal', models.ForeignKey(verbose_name='dismissal.dismissal_request', related_name='maillists', to='dismissal.Dismissal')),
            ],
            options={
                'verbose_name': 'dismissal.maillist_duty',
                'verbose_name_plural': 'dismissal.maillist_duty',
            },
        ),
    ]
