from django.conf import settings

from staff.django_intranet_notifications import Notification
from staff.person.models import Staff
from staff.dismissal.models import Dismissal


class DismissalNotificationContext(dict):
    def __init__(self, staff: Staff, dismissal: Dismissal = None, **kwargs):
        self['settings'] = settings
        self['staff'] = staff

        if dismissal is not None:
            self['dismissal'] = dismissal

        self.update(kwargs)
        super(DismissalNotificationContext, self).__init__()


class DismissalNotification(Notification):
    def __init__(self, context: DismissalNotificationContext, **kwargs):
        super(DismissalNotification, self).__init__(context=context, **kwargs)

    def get_subj_id(self):
        if 'dismissal' in self.context:
            subj_id = 'dismissal_%s' % self.context['dismissal'].id
        else:
            person = self.context['staff']
            subj_id = 'dismissal_%s' % person.login
            if person.quit_at:
                subj_id += '_%s' % person.quit_at.isoformat()
        return subj_id


class CreationNotification(DismissalNotification):
    template = 'notifications/dismissal_created.html'


class UpdateNotification(DismissalNotification):
    template = 'notifications/dismissal_updated.html'


class CancellationNotification(DismissalNotification):
    template = 'notifications/dismissal_cancelled.html'


class CompletionSuperiorNotification(DismissalNotification):
    template = 'notifications/dismissal_completed_superior.html'


class CompletionNotification(DismissalNotification):
    template = 'notifications/dismissal_completed.html'


class MailFilesActionsNotification(DismissalNotification):
    template = 'notifications/dismissal_mail_files_actions.html'


class QuitDateNotification(DismissalNotification):
    template = 'notifications/dismissal_quit_date.html'


class NotCompletedNotification(DismissalNotification):
    template = 'notifications/dismissal_not_completed.html'


class DatePassedNotification(DismissalNotification):
    template = 'notifications/dismissal_date_passed.html'


class MailSearchDeletionNotification(DismissalNotification):
    template = 'notifications/dismissal_seek-access.html'
