from staff.users.models import User
from staff.person.dis_staff_services import StaffService


def is_superior(first_user, second_user):
    """Проверка руководитель/заместитель (chief/deputy) - подчиненный

    Проверяем является ли first_user руководителем или заместителем в цепочке
    департаментов сотрудника second_user

    @param first_user: Staff - владелец анкеты
    @param second_user: Staff - запрашивающий
    @return: bool
    """

    # TODO: переделать все места где принимает User на Staff и убрать проверку
    if isinstance(first_user, User):
        first_user = first_user.staff
    if isinstance(second_user, User):
        second_user = second_user.staff

    return first_user in StaffService(second_user).get_superiors()


class DismissalPerms(object):
    """
    Проверки прав и прочие сервисы, связанные с увольнениями.
    В аргументах передаются модели django_intranet_stuff.Staff
    """

    @staticmethod
    def can_create_dismissal(subject, object_):
        # hr, руководитель, безопасники
        return (subject.user.has_perm('dismissal.can_create_dismissal') or
                is_superior(subject, object_))

    @staticmethod
    def can_update_dismissal(subject, dismissal):
        # hr, руководитель, автор
        return (subject.user.has_perm('dismissal.can_update_dismissal') or
                is_superior(subject, dismissal.staff) or
                subject == dismissal.created_by)

    @staticmethod
    def can_cancel_dismissal(subject, dismissal):
        # hr, руководитель
        return (subject.user.has_perm('dismissal.can_cancel_dismissal') or is_superior(subject, dismissal.staff))

    @staticmethod
    def can_dismiss_from_anketa(subject, object_):
        """Может увольнять ссылкой с анкеты"""
        return (subject.user.has_perm('dismissal.can_dismiss_from_anketa') or is_superior(subject, object_))

    @staticmethod
    def can_dismiss_from_chit(subject, object_):
        """Может увольнять кнопкой с обходного"""
        return subject.user.has_perm('dismissal.can_dismiss_from_chit')

    @staticmethod
    def can_see_hr_note(subject, object_):
        # hr, руководитель
        return (subject.user.has_perm('dismissal.can_see_hr_note') or
                is_superior(subject, object_))

    @staticmethod
    def can_set_deadline(subject):
        return subject.user.has_perm('dismissal.can_dismiss_from_anketa')

    @staticmethod
    def can_check(subject, checkpoint):
        checkpoint_tpl = checkpoint.template
        if checkpoint_tpl:
            return subject in checkpoint_tpl.responsibles.all()
        else:
            return False
