from operator import and_
from functools import reduce

from django.db.models import Q
from django.conf import settings

from .models import Dismissal
from staff.reports.utils import filters

EXCLUDE_VIRTUAL_OFFICE_DISMISSAL = Q(staff__office=settings.VIRTUAL_OFFICE_ID)


def get_dismissals(*filter_options):
    fields = [
        'id',
        'staff',
        'status',
        'department',
        'office',
        'quit_date',
        'quit_datetime_real',
        'note',
        'quit_datetime_real',
        'created_at',
        'created_by',
        'completed_by',
        'initiator',
        'need_hr_help',
        'reason',
        'new_employer',
        'impression',
        'delete_email_address',
        'delete_correspondence',
        'forward_correspondence_to',
        'give_files_to',
        'rehire_recommendation',
    ]
    filter_options = reduce(and_, filter_options, filters['YANDEX_ONLY_FROM_STAFF'])
    dismissals = (
        Dismissal.objects
        .values(*fields)
        .filter(filter_options)
        .exclude(EXCLUDE_VIRTUAL_OFFICE_DISMISSAL)
    )
    return dismissals
