from django.contrib.auth.decorators import permission_required
from staff.lib.decorators import responding_xlsx
from .reports import DismissalReport


@permission_required('django_intranet_stuff.can_view_dismissal_report', raise_exception=True)
@responding_xlsx(prefix='yandex_dismissal')
def yandex_dismissal(request):
    """
    Заявки на увольнение
    (Все данные только на русском языке)
        * Имя Отчество Фамилия
        * Логин
        * Дата найма
        * Цепочка подразделений
        * Офис
        * Логин руководителя
        * Дата создания заявки на увольнение
        * Логин сотрудника, который создал заявку
        * Цепочка подразделений сотрудника, который создал заявку
        * Логин сотрудника, который уволил
        * Дата увольнения (как указано в заявке)
        * Дата увольнения сотрудника (по данным Стаффа)
        * Флаг is_dismissed
        * Статус заявки
        * Инициатор
        * Нужна помощь HR
        * Комментарий для HR
        * Причина ухода
        * Новое место работы
        * Отношение к уходу
        * Удалить емейл
        * Удалить почту
        * Кому перенаправлять почту (логин)
        * Кому архивировать и передать почту (логин)
    """
    return [DismissalReport().as_table()]
