from django.dispatch import Signal

dismissal_created = Signal(providing_args=['dismissal'])
dismissal_updated = Signal(providing_args=['dismissal', 'updated_by', 'changes'])
dismissal_cancelled = Signal(providing_args=['dismissal', 'cancelled_by'])
dismissal_completed = Signal(
    providing_args=[
        'request',
        'staff',
        'dismissal',
        'staff_was_chief',
        'staff_was_deputy',
    ]
)

# наступил день увольнения
dismissal_quit_date = Signal(providing_args=['dismissal'])
# сотрудник уволен, пункт обходного не заполнен
dismissal_not_completed = Signal(providing_args=['dismissal'])
# сотрудник не уволен, хотя дата прошла
dismissal_date_passed = Signal(providing_args=['dismissal'])
