from django.conf.urls import url

from staff.views import frontend_view

from staff.dismissal.debug import views as debug_views


urlpatterns = [
    url(
        r'^$',
        frontend_view,
        name='dismissal-list',
    ),
    url(
        r'^create/?$',
        frontend_view,
        name='dismissal-create',
    ),
    url(
        r'^_create/(?P<login>[\w\-\_\.]+)/?$',
        frontend_view,
        name='dismissal-create-with-params',
    ),
    url(
        r'^complete/?$',
        frontend_view,
        name='dismissal-complete',
    ),
    url(
        r'^(?P<pk>\d+)/?$',
        frontend_view,
        name='dismissal-edit',
    ),
    url(
        r'^check_point/?$',
        frontend_view,
        name='dismissal-check',
    ),

    url(r'^debug/?$', debug_views.index, name='dismissal-debug-index'),
    url(r'^debug/chit/?$', debug_views.chit, name='dismissal-debug-chit'),
    url(r'^debug/checkpoints/?$', debug_views.checkpoint_perms, name='dismissal-debug-checkpoints'),
    url(r'^debug/dismissals/?$', debug_views.dismissals, name='dismissal-debug-dismissals'),
    url(r'^debug/creating/?$', debug_views.creating, name='dismissal-debug-creating'),
]
