from django.conf.urls import url

from staff.dismissal_api import views

urlpatterns = [
    url(r'^filter/?$', views.dismissal_list, name='filter'),
    url(r'^create/(?P<login>[\w\-\_\.]+)/?$', views.create_dismissal, name='create'),
    url(r'^(?P<dismissal_id>\d+)/?$', views.get_dismissal, name='get_dismissal'),
    url(r'^(?P<dismissal_id>\d+)/edit/?$', views.edit_dismissal, name='edit'),

    url(r'^(?P<dismissal_id>\d+)/cancel/?$', views.cancel_dismissal, name='cancel'),
    url(r'^(?P<dismissal_id>\d+)/complete/?$', views.complete_dismissal, name='complete'),
    url(r'^checkpoint/(?P<checkpoint_id>\d+)/?$', views.confirm_checkpoint, name='confirm_checkpoint'),
]
