from django.contrib import admin
from staff.django_api_auth.models import Token


class ApiAdmin(admin.ModelAdmin):
    search_fields = (
        'token',
        'description',
        'hostnames',
        'ips',
    )
    list_display = (
        'token',
        'description',
        'created_at',
        'modified_at',
    )


admin.site.register(Token, ApiAdmin)
