from django.conf import settings
from django.core.cache import caches


CSRF_DOMAINS = getattr(
    settings,
    'API_AUTH_CSRF_DOMAINS',
    ('.yandex-team.ru', '.yandex.ru')
)
TOKEN_VAR = getattr(settings, 'API_AUTH_TOKEN_VAR', 'token')
TOKEN_HEADER = getattr(
    settings,
    'API_AUTH_HEADER_NAME',
    'HTTP_X_YANDEX_DJANGO_API_AUTH'
)
CACHE_TIMEOUT = getattr(settings, 'API_AUTH_CACHE_TIMEOUT', 3600)
CACHE_PREFIX = getattr(settings, 'API_AUTH_CACHE_PREFIX', 'API_AUTH_')
CACHE_NAME = getattr(settings, 'API_AUTH_CACHE_NAME', 'default')

CACHE = caches[CACHE_NAME]


def get_key(token, ip):
    return '%s|%s|%s' % (CACHE_PREFIX, token, ip)
