from django.contrib import admin
from staff.lib.forms.fields import StaffField
from .models import Route

js_autocompletes = (
    '//js.static.yandex.net/jquery/1.3.2/_jquery.js',
    '//center.yandex-team.ru/media/js/_js-autocomplete_groups.js',
    '//center.yandex-team.ru/media/js/_js-autocomplete_staff.js',
)


class RouteAdmin(admin.ModelAdmin):
    list_display = ('target', 'department', 'office', 'staff', 'transport_id',
                    'params')

    def formfield_for_dbfield(self, db_field, **kwargs):
        field = super(RouteAdmin, self).formfield_for_dbfield(db_field, **kwargs)

        if db_field.name == 'staff':
            field = StaffField(required=field.required)

        return field

    class Media:
        js = js_autocompletes


admin.site.register(Route, RouteAdmin)
