from email.header import make_header

from django.core import mail


class MessageWrapper(object):
    message_class = mail.EmailMessage

    def __init__(self):
        self.mail = self.message_class()
        self.mail.encoding = "UTF-8"
        self.mail.content_subtype = "html"

    def set_subject(self, subject):
        self.mail.subject = subject

    def set_to(self, emails):
        for email in emails:
            self.mail.to.append(email)

    def set_sender(self, sender):
        if isinstance(sender, (tuple, list)):
            self.mail.extra_headers["From"] = make_header([
                (sender[0].encode('utf-8'), "utf-8"), ("<" + sender[1] + ">", "us-ascii")
            ])
        else:
            self.mail.extra_headers["From"] = sender

    def set_body(self, body):
        self.mail.body = body

    def set_message_id(self, id):
        self.mail.extra_headers["Message-Id"] = id

    def set_reply_to(self, id):
        self.mail.extra_headers["In-Reply-To"] = id
        self.mail.extra_headers["References"] = id

    def set_extra_headers(self, headers):
        self.mail.extra_headers.update(headers)

    def send_raw_email(self):
        self.mail.send()
