# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='MessageThreadModel',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('subj_id', models.CharField(max_length=150)),
                ('target', models.CharField(max_length=150)),
                ('transport_id', models.CharField(max_length=150)),
                ('last_msg_id', models.CharField(max_length=150, null=True)),
            ],
            options={
                'db_table': 'notifications_messagethread',
            },
        ),
        migrations.CreateModel(
            name='Route',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('target', models.CharField(max_length=128, blank=True, null=True)),
                ('transport_id', models.CharField(max_length=128)),
                ('params', models.CharField(max_length=1024)),
            ],
            options={
                'db_table': 'notifications_route',
            },
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('article_id', models.PositiveIntegerField()),
                ('article_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='contenttypes.ContentType')),
            ],
            options={
                'db_table': 'notifications_subscription',
            },
        ),
    ]
