from django.db import models
from django.contrib.contenttypes import fields


class Route(models.Model):
    class Meta:
        db_table = 'notifications_route'
        app_label = 'django_intranet_notifications'

    department = models.ForeignKey('django_intranet_stuff.Department',
                                   null=True,
                                   blank=True,
                                   on_delete=models.SET_NULL)
    office = models.ForeignKey('django_intranet_stuff.Office',
                               null=True,
                               blank=True,
                               on_delete=models.SET_NULL)
    staff = models.ForeignKey('django_intranet_stuff.Staff',
                              null=True,
                              blank=True,
                              on_delete=models.SET_NULL)
    target = models.CharField(max_length=128, null=True, blank=True)

    transport_id = models.CharField(max_length=128)
    params = models.CharField(max_length=1024)

    def __str__(self):
        return f'{self.department} {self.office} {self.staff}, {self.target}'

    def save(self, *args, **kwargs):

        if not self.target:
            self.target = None

        super(Route, self).save(*args, **kwargs)


class Subscription(models.Model):
    class Meta:
        db_table = 'notifications_subscription'
        app_label = 'django_intranet_notifications'

    article_type = models.ForeignKey('contenttypes.ContentType',
                                     on_delete=models.PROTECT)
    article_id = models.PositiveIntegerField()
    article = fields.GenericForeignKey('article_type', 'article_id')

    staff = models.ForeignKey('django_intranet_stuff.Staff',
                              on_delete=models.CASCADE)


class MessageThreadModel(models.Model):
    class Meta:
        db_table = 'notifications_messagethread'
        app_label = 'django_intranet_notifications'
        index_together = (
            ('subj_id', 'target', 'transport_id', 'last_msg_id'),
        )

    subj_id = models.CharField(max_length=150)
    target = models.CharField(max_length=150)
    transport_id = models.CharField(max_length=150)
    last_msg_id = models.CharField(max_length=150, null=True)
