from requests.exceptions import RequestException

from django.conf import settings

from staff.lib import requests, tvm2


class WikiFormatter:

    def __init__(self, cfg='intranet'):
        self.url = f'{settings.WIKIFORMATTER_URL}?cfg={cfg}'

    def to_html(self, text):
        headers = {
            'User-Agent': settings.PROJECT_NAME,
            tvm2.TVM_SERVICE_TICKET_HEADER: tvm2.get_tvm_ticket_by_deploy('wiki-formatter'),
        }

        try:
            response = requests.post(self.url, data={'text': text}, headers=headers)
            return response.text
        except RequestException:
            return text
