# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.contrib.postgres.fields


class Migration(migrations.Migration):

    dependencies = [
        ('budget_position', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='City',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('color', models.CharField(max_length=6, default='000000')),
                ('position', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=100)),
                ('name_en', models.CharField(max_length=100, blank=True, default='')),
                ('geo_id', models.IntegerField(default=0)),
            ],
            options={
                'db_table': 'intranet_city',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('color', models.CharField(max_length=6, default='000000')),
                ('position', models.IntegerField(default=0)),
                ('name', models.CharField(max_length=100)),
                ('name_en', models.CharField(max_length=100)),
                ('yandex_domain', models.CharField(max_length=100)),
                ('code', models.CharField(max_length=2, blank=True, default='')),
                ('geo_base_id', models.IntegerField()),
            ],
            options={
                'db_table': 'intranet_country',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('position', models.IntegerField(default=0)),
                ('from_staff_id', models.PositiveIntegerField(db_index=True)),
                ('name', models.CharField(max_length=255)),
                ('name_en', models.CharField(max_length=255, default='')),
                ('short_name', models.CharField(max_length=255, default='')),
                ('short_name_en', models.CharField(max_length=255, default='')),
                ('version', models.IntegerField(default=1)),
                ('code', models.CharField(max_length=20, default='')),
                ('url', models.CharField(max_length=255, unique=True, default='')),
                ('dynamic_url', models.CharField(max_length=255, unique=True, null=True)),
                ('bg_color', models.CharField(max_length=20, default='')),
                ('fg_color', models.CharField(max_length=20, default='')),
                ('maillists', models.CharField(max_length=4096, default='')),
                ('clubs', models.CharField(max_length=4096, default='')),
                ('wiki_page', models.CharField(max_length=2048, default='')),
                ('jira_project', models.CharField(max_length=255, default='')),
                ('description', models.CharField(max_length=4096, default='')),
                ('description_en', models.CharField(max_length=4096, default='')),
                ('is_expanded', models.BooleanField(default=False, help_text='Разворачивается при открытии интерфейса структуры')),
                ('is_hidden', models.BooleanField(default=False, help_text='Ветка скрывается в интерфейсе структуры')),
                ('is_cut_out', models.BooleanField(default=False, help_text='Вырезано из иерархии в интерфейсе, а дети подятнуты к родителю выше')),
                ('tags', django.contrib.postgres.fields.ArrayField(blank=True, null=True, help_text='Теги, которые выводятся в интерфейсе структуру, например `Бизнесс юнит`', base_field=models.CharField(max_length=64, choices=[('business_unit', 'business_unit'), ('experiment', 'experiment')]), size=None)),
                ('category', models.CharField(max_length=30, default='nontechnical', choices=[('nontechnical', 'nontechnical category'), ('technical', 'technical category')])),
                ('instance_class', models.CharField(max_length=16, default='department', choices=[('department', 'department'), ('valuestream', 'valuestream')])),
                ('oebs_creation_date', models.DateField(blank=True, null=True)),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
            ],
            options={
                'db_table': 'intranet_department',
                'permissions': (('can_view_departments', 'Can view departments'), ('can_view_profiles', 'Can view profiles'), ('can_view_all_blocks', 'Can view all blocks on permitted profiles'), ('can_view_gaps', 'Can view gaps'), ('can_view_finance', 'Can view finance cab')),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DepartmentKind',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('name', models.CharField(max_length=64)),
                ('name_en', models.CharField(max_length=64, blank=True)),
                ('rank', models.IntegerField(default=0)),
                ('slug', models.CharField(max_length=64, unique=True, null=True)),
            ],
            options={
                'db_table': 'intranet_department_kind',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DepartmentStaff',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
            ],
            options={
                'db_table': 'intranet_departmentstaff',
            },
        ),
        migrations.CreateModel(
            name='DepartmentStaffCounter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('day', models.DateField(db_index=True)),
                ('staff_counter', models.PositiveSmallIntegerField()),
            ],
            options={
                'db_table': 'intranet_departmentstaffcounter',
            },
        ),
        migrations.CreateModel(
            name='Device',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('from_staff_id', models.PositiveIntegerField(db_index=True)),
                ('type', models.PositiveSmallIntegerField(default=0, choices=[(0, 'intranet_stuff.Device_Printer'), (1, 'intranet_stuff.Device_Scanner'), (2, 'intranet_stuff.Device_Copier'), (3, 'intranet_stuff.Device_MFP'), (4, 'intranet_stuff.Device_DECT'), (5, 'intranet_stuff.Device_WiFi'), (6, 'intranet_stuff.Device_RJ45'), (7, 'intranet_stuff.Device_Fax'), (8, 'intranet_stuff.Device_Shredder'), (9, 'intranet_stuff.Device_CCTV'), (10, 'intranet_stuff.Device_Stationery'), (11, 'intranet_stuff.Device_Lock'), (12, 'intranet_stuff.Device_Hypercube'), (13, 'intranet_stuff.Device_Sensor'), (14, 'intranet_stuff.Device_Zombie'), (15, 'intranet_stuff.Device_WiFi_MountPlatform'), (16, 'intranet_stuff.Device_WiFi_Sensor'), (17, 'intranet_stuff.Device_Vending_Machine'), (18, 'intranet_stuff.Device_Help_Machine'), (19, 'intranet_stuff.Device_ATM'), (20, 'intranet_stuff.Device_MassageChair')])),
                ('name', models.CharField(max_length=255)),
                ('name_dns', models.CharField(max_length=255, default='')),
                ('description', models.TextField(default='')),
                ('coord_x', models.IntegerField(null=True)),
                ('coord_y', models.IntegerField(null=True)),
                ('color', models.CharField(max_length=10, default='')),
                ('angle', models.PositiveSmallIntegerField(default=0)),
            ],
            options={
                'db_table': 'intranet_printer',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Floor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('position', models.IntegerField(default=0)),
                ('from_staff_id', models.PositiveIntegerField(db_index=True)),
                ('name', models.CharField(max_length=50)),
                ('name_en', models.CharField(max_length=50, default='')),
                ('num', models.IntegerField(null=True)),
                ('coord_x', models.IntegerField(null=True)),
                ('coord_y', models.IntegerField(null=True)),
                ('img', models.CharField(max_length=1024, blank=True, null=True)),
            ],
            options={
                'db_table': 'intranet_floor',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('service_id', models.PositiveIntegerField(blank=True, null=True, db_index=True)),
                ('role_scope_id', models.CharField(max_length=127, blank=True, null=True)),
                ('name', models.CharField(max_length=1270, db_index=True)),
                ('url', models.CharField(max_length=255, unique=True, db_index=True)),
                ('code', models.CharField(max_length=127, db_index=True, default='')),
                ('description', models.TextField()),
                ('position', models.IntegerField(null=True, default=0)),
                ('type', models.PositiveSmallIntegerField(default=0, choices=[(0, 'wiki'), (1, 'department'), (2, 'service'), (3, 'servicerole')])),
                ('externals_count', models.PositiveIntegerField(default=0)),
                ('yandex_count', models.PositiveIntegerField(default=0)),
                ('yamoney_count', models.PositiveIntegerField(default=0)),
                ('service_tags', models.CharField(max_length=128, blank=True, default='')),
                ('parent_service_id', models.IntegerField(blank=True, null=True, default=None)),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
            ],
            options={
                'db_table': 'intranet_group',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GroupMembership',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('joined_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'db_table': 'intranet_groupmembership',
            },
        ),
        migrations.CreateModel(
            name='GroupResponsible',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('permitted_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'db_table': 'intranet_groupresponsible',
            },
        ),
        migrations.CreateModel(
            name='MemorialProfile',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(verbose_name='Признак активности', default=0, help_text='0=Выкл, 1=Вкл')),
                ('status_block_html', models.TextField(verbose_name='Код содержимого плашки', default='')),
                ('status_block_html_en', models.TextField(verbose_name='Код содержимого плашки (англ)', default='')),
                ('death_date', models.DateField(verbose_name='Дата смерти')),
            ],
            options={
                'db_table': 'intranet_memorial_profile',
            },
        ),
        migrations.CreateModel(
            name='Office',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('position', models.IntegerField(default=0)),
                ('from_staff_id', models.PositiveIntegerField(db_index=True)),
                ('name', models.CharField(max_length=255)),
                ('name_en', models.CharField(max_length=255, default='')),
                ('is_virtual', models.BooleanField(verbose_name='Виртуальный', default=False)),
                ('address1', models.CharField(max_length=255, default='')),
                ('address2', models.CharField(max_length=255, default='')),
                ('address1_en', models.CharField(max_length=255, default='')),
                ('address2_en', models.CharField(max_length=255, default='')),
                ('phone', models.CharField(max_length=50, default='')),
                ('fax', models.CharField(max_length=50, default='')),
                ('tz', models.CharField(max_length=20, default='')),
                ('color', models.CharField(max_length=10)),
                ('have_map', models.BooleanField(default=False)),
                ('coord_x', models.FloatField(null=True)),
                ('coord_y', models.FloatField(null=True)),
                ('zoom', models.PositiveSmallIntegerField(default=0)),
                ('code', models.CharField(max_length=20, default='')),
                ('filter_id', models.CharField(max_length=40, blank=True, default='')),
            ],
            options={
                'db_table': 'intranet_office',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('position', models.IntegerField(default=0)),
                ('from_staff_id', models.PositiveIntegerField(db_index=True)),
                ('name', models.CharField(max_length=50)),
                ('name_en', models.CharField(max_length=50)),
                ('chief', models.CharField(max_length=50, default='')),
                ('deputy', models.CharField(max_length=50, default='')),
                ('color', models.CharField(max_length=10, default='')),
                ('textcolor', models.CharField(max_length=10, default='')),
                ('filter_id', models.CharField(max_length=40, blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
            ],
            options={
                'db_table': 'intranet_organization',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Room',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('from_staff_id', models.PositiveIntegerField(blank=True, null=True, db_index=True)),
                ('num', models.PositiveIntegerField(verbose_name='Номер комнаты', blank=True, null=True)),
                ('name', models.CharField(max_length=255, default='')),
                ('name_en', models.CharField(max_length=255, default='')),
                ('name_exchange', models.CharField(max_length=50, db_index=True, default='')),
                ('name_alternative', models.CharField(max_length=255, default='')),
                ('room_type', models.PositiveSmallIntegerField(default=1, choices=[(0, 'intranet_stuff.Room_Office'), (1, 'intranet_stuff.Room_ConferenceRoom'), (2, 'intranet_stuff.Room_SmokingArea'), (3, 'intranet_stuff.Room_CoffeePoint'), (4, 'intranet_stuff.Room_WC'), (5, 'intranet_stuff.Room_Wardrobe'), (6, 'intranet_stuff.Room_Warehouse'), (7, 'intranet_stuff.Room_StaffOnly'), (8, 'intranet_stuff.Room_Shower'), (9, 'intranet_stuff.Room_Gym'), (10, 'intranet_stuff.Room_Library'), (11, 'intranet_stuff.Room_Coworking'), (12, 'intranet_stuff.Room_Stairs'), (13, 'intranet_stuff.Room_Switch'), (14, 'intranet_stuff.Room_Hallway'), (15, 'intranet_stuff.Room_Balcony'), (16, 'intranet_stuff.Room_PhoneBooth')])),
                ('coord_x', models.IntegerField(default=0)),
                ('coord_y', models.IntegerField(default=0)),
                ('color', models.CharField(max_length=10, default='')),
                ('geometry', models.CharField(max_length=2055, default='')),
                ('phone', models.CharField(verbose_name='номер телефона', max_length=50, blank=True, default='')),
                ('iso_x', models.IntegerField(verbose_name='координата X для киоска', blank=True, null=True)),
                ('iso_y', models.IntegerField(verbose_name='координата Y для киоска', blank=True, null=True)),
                ('iso_label_pos', models.CharField(verbose_name='Положение указателя для киоска', max_length=2, blank=True, default='', choices=[('', 'снизу в центре'), ('br', 'снизу слева'), ('bl', 'снизу справа'), ('r', 'слева'), ('l', 'справа')])),
                ('hide_floor_num', models.BooleanField(verbose_name='Показывать без номера этажа в киосках', default=False)),
                ('order', models.PositiveSmallIntegerField(verbose_name='порядок', blank=True, null=True)),
                ('label_pos', models.CharField(verbose_name='Подпись переговорки', max_length=1, default='T', choices=[('T', 'над помещением'), ('B', 'под помещением')])),
                ('projector', models.PositiveSmallIntegerField(verbose_name='проектор', blank=True, null=True, help_text='количество')),
                ('panel', models.PositiveSmallIntegerField(verbose_name='ЖК/Плазменная панель', blank=True, null=True, help_text='количество')),
                ('seats', models.PositiveSmallIntegerField(verbose_name='число посадочных мест', blank=True, null=True)),
                ('marker_board', models.BooleanField(verbose_name='маркерная доска', default=False)),
                ('cork_board', models.BooleanField(verbose_name='пробковая доска', default=False)),
                ('video_conferencing', models.CharField(verbose_name='видео конференц-связь', max_length=10, blank=True, null=True, help_text='номер')),
                ('voice_conferencing', models.BooleanField(verbose_name='голосовая конференц-связь', default=False)),
                ('game_console', models.CharField(verbose_name='игровая приставка', max_length=255, blank=True, null=True, help_text='если есть, то какая')),
                ('capacity', models.CharField(verbose_name='вместимость', max_length=255, blank=True, null=True, help_text='оценка числа человек')),
                ('additional', models.TextField(verbose_name='дополнительная информация', blank=True, null=True)),
                ('desk', models.BooleanField(verbose_name='стол', default=False)),
                ('is_cabin', models.BooleanField(verbose_name='Это домик', default=False)),
                ('is_avallable_for_reserve', models.BooleanField(verbose_name='Доступна для бронирования', default=False)),
                ('guest_wifi', models.BooleanField(verbose_name='Гостевой Wi-Fi', default=False)),
            ],
            options={
                'db_table': 'intranet_room',
                'permissions': (('add_conference_room', 'Can add conference room'), ('change_conference_room', 'Can change conference room'), ('delete_conference_room', 'Can delete conference room'), ('add_coworking_room', 'Can add coworking room'), ('change_coworking_room', 'Can change coworking room'), ('delete_coworking_room', 'Can delete coworking room')),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Staff',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('from_staff_id', models.PositiveIntegerField(db_index=True, default=0)),
                ('login', models.CharField(max_length=50, db_index=True, default='')),
                ('normal_login', models.CharField(max_length=50, db_index=True, default='')),
                ('login_mail', models.CharField(max_length=50, db_index=True, default='')),
                ('domain', models.CharField(max_length=1, default='', choices=[('A', 'auto.ru'), ('C', 'comptek.ru'), ('Y', 'yandex-team.ru'), ('U', 'yandex-team.com.ua'), ('M', 'yamoney.ru'), ('P', 'yaprobki.ru'), ('W', 'yandex-team.com'), ('T', 'yandex-team.com.tr')])),
                ('login_ld', models.CharField(max_length=50, unique=True, db_index=True)),
                ('uid', models.CharField(max_length=16, unique=True, null=True, db_index=True)),
                ('guid', models.CharField(max_length=47, null=True, default='')),
                ('login_passport', models.CharField(max_length=100, unique=True, null=True, db_index=True)),
                ('first_name', models.CharField(max_length=50, db_index=True, default='')),
                ('first_name_en', models.CharField(max_length=50, db_index=True, default='')),
                ('middle_name', models.CharField(max_length=50, default='')),
                ('hide_middle_name', models.BooleanField(default=True)),
                ('preferred_name', models.CharField(max_length=50, default='')),
                ('preferred_name_en', models.CharField(max_length=50, default='')),
                ('last_name', models.CharField(max_length=100, db_index=True, default='')),
                ('last_name_en', models.CharField(max_length=100, db_index=True, default='')),
                ('en_name', models.CharField(max_length=255, default='')),
                ('tz', models.CharField(max_length=30, default='')),
                ('auto_translate', models.BooleanField(default=False)),
                ('date_completion_internship', models.DateField(null=True, default=None)),
                ('is_homeworker', models.BooleanField(default=False)),
                ('is_robot', models.BooleanField(default=False)),
                ('affiliation', models.CharField(max_length=32, db_index=True, choices=[('yandex', 'intranet_stuff.Staff_AffiliationYandex'), ('yamoney', 'intranet_stuff.Staff_AffiliationYamoney'), ('external', 'intranet_stuff.Staff_AffiliationExternal')])),
                ('work_mode', models.CharField(max_length=16, blank=True, null=True, default=None, choices=[('remote', 'intranet_stuff.Staff_WorkModeRemote'), ('office', 'intranet_stuff.Staff_WorkModeOffice'), ('mixed', 'intranet_stuff.Staff_WorkModeMixed')])),
                ('has_exchange', models.BooleanField(default=False)),
                ('has_namesake', models.BooleanField(default=False)),
                ('birthday', models.DateField(null=True)),
                ('hide_birthday_year', models.BooleanField(default=False)),
                ('gender', models.CharField(max_length=1, default='', choices=[('M', 'intranet_stuff.Staff_Male'), ('F', 'intranet_stuff.Staff_Female')])),
                ('family_status', models.CharField(max_length=1, default='', choices=[('S', 'intranet_stuff.Staff_SingleMale'), ('M', 'intranet_stuff.Staff_MarriedMale')])),
                ('children', models.PositiveSmallIntegerField(null=True)),
                ('car', models.CharField(max_length=100, default='')),
                ('car_num', models.CharField(max_length=100, default='')),
                ('address', models.CharField(max_length=1024, default='')),
                ('address_en', models.CharField(max_length=1024, default='')),
                ('edu_status', models.CharField(max_length=1, default='', choices=[('S', 'intranet_stuff.Staff_SecondaryEducation'), ('I', 'intranet_stuff.Staff_HigherIncompleteEducation'), ('B', 'intranet_stuff.Staff_BachelorsDegreeEducation'), ('M', 'intranet_stuff.Staff_MastersDegreeEducation'), ('P', 'intranet_stuff.Staff_SpecialistDegreeEducation'), ('D', 'intranet_stuff.Staff_AcademicDegreeEducation')])),
                ('edu_direction', models.CharField(max_length=1, default='', choices=[('T', 'intranet_stuff.Staff_TechnicalDirection'), ('L', 'intranet_stuff.Staff_LiberalDirection'), ('N', 'intranet_stuff.Staff_NaturalDirection'), ('E', 'intranet_stuff.Staff_EconomicDirection'), ('B', 'intranet_stuff.Staff_BusinessDirection')])),
                ('edu_place', models.CharField(max_length=255, default='')),
                ('edu_place_en', models.CharField(max_length=255, default='')),
                ('edu_date', models.DateField(null=True)),
                ('is_big_boss', models.BooleanField(default=False)),
                ('is_dismissed', models.BooleanField(default=False)),
                ('desk_id', models.IntegerField(null=True)),
                ('join_at', models.DateField(null=True)),
                ('quit_at', models.DateField(null=True)),
                ('position', models.CharField(max_length=150, default='')),
                ('position_en', models.CharField(max_length=150, default='')),
                ('employment', models.CharField(max_length=1, default='', choices=[('F', 'intranet_stuff.Staff_FullEmployment'), ('P', 'intranet_stuff.Staff_PartTimeEmployment'), ('D', 'intranet_stuff.Staff_SecondaryJob')])),
                ('work_phone', models.PositiveIntegerField(null=True, db_index=True)),
                ('mobile_phone', models.CharField(max_length=100, default='')),
                ('mobile_phone_idx', models.CharField(max_length=100, db_index=True, default='')),
                ('work_email', models.CharField(max_length=100, db_index=True, default='')),
                ('home_email', models.CharField(max_length=100, db_index=True, default='')),
                ('home_phone', models.CharField(max_length=100, default='')),
                ('home_page', models.CharField(max_length=100, default='')),
                ('icq', models.CharField(max_length=50, default='')),
                ('jabber', models.CharField(max_length=100, default='')),
                ('login_skype', models.CharField(max_length=50, default='')),
                ('login_mk', models.CharField(max_length=50, default='')),
                ('login_twitter', models.CharField(max_length=50, default='')),
                ('login_lj', models.CharField(max_length=50, default='')),
                ('login_crm', models.CharField(max_length=50, default='')),
                ('wiki_name', models.CharField(max_length=100, db_index=True, default='')),
                ('about', models.CharField(max_length=1024, default='')),
                ('tshirt_size', models.CharField(max_length=4, default='', choices=[('XXS', 'XXS'), ('XS', 'XS'), ('S', 'S'), ('M', 'M'), ('L', 'L'), ('XL', 'XL'), ('XXL', 'XXL'), ('XXXL', 'XXXL'), ('4XL', '4XL')])),
                ('mobile_phone_model', models.CharField(max_length=100, default='')),
                ('computer', models.CharField(max_length=150, default='')),
                ('location_descr', models.CharField(max_length=255, default='')),
                ('location_descr_en', models.CharField(max_length=255, default='')),
                ('duties', models.CharField(max_length=1024, default='')),
                ('duties_en', models.CharField(max_length=1024, default='')),
                ('vacation', models.FloatField(null=True, default=0)),
                ('extra_vacation', models.FloatField(null=True, default=0)),
                ('paid_day_off', models.FloatField(null=True)),
                ('passwd_set_at', models.DateTimeField(null=True)),
                ('lang_ui', models.CharField(max_length=2, default='', choices=[('en', 'English'), ('ru', 'Russian'), ('tr', 'Turkish')])),
                ('lang_content', models.CharField(max_length=255, default='')),
                ('photos', models.PositiveSmallIntegerField(default=0)),
                ('in_office_from', models.TimeField(null=True)),
                ('in_office_to', models.TimeField(null=True)),
                ('is_login_passport_confirmed', models.BooleanField(default=False)),
                ('show_all_middle_name', models.BooleanField(default=False)),
                ('show_beta_interface', models.BooleanField(default=False)),
                ('shell', models.CharField(max_length=50, default='/bin/bash')),
                ('budget_position', models.ForeignKey(null=True, on_delete=django.db.models.deletion.PROTECT, to='budget_position.BudgetPosition')),
                ('department', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Department')),
                ('office', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='django_intranet_stuff.Office')),
                ('organization', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Organization')),
                ('room', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Room')),
            ],
            options={
                'db_table': 'intranet_staff',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StaffCar',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('position', models.IntegerField(default=0)),
                ('model', models.CharField(max_length=100, default='')),
                ('plate', models.CharField(max_length=50, default='')),
                ('staff', models.ForeignKey(related_name='cars', to='django_intranet_stuff.Staff')),
            ],
            options={
                'db_table': 'intranet_staff_car',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StaffPhone',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('position', models.IntegerField(default=0)),
                ('number', models.CharField(max_length=50)),
                ('type', models.PositiveSmallIntegerField(default=2, choices=[(2, 'intranet_stuff.StaffPhones_Mobile'), (3, 'intranet_stuff.StaffPhones_Home')])),
                ('protocol', models.CharField(max_length=50, default='all', choices=[('all', 'all'), ('sms', 'sms'), ('voice', 'voice')])),
                ('kind', models.CharField(max_length=50, default='common', choices=[('common', 'common'), ('emergency', 'emergency'), ('monitoring', 'monitoring'), ('hidden', 'hidden')])),
                ('description', models.CharField(max_length=255, default='')),
                ('for_digital_sign', models.BooleanField(default=False)),
                ('staff', models.ForeignKey(related_name='phones', to='django_intranet_stuff.Staff')),
            ],
            options={
                'db_table': 'intranet_staff_phone',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Table',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('from_staff_id', models.PositiveIntegerField(db_index=True)),
                ('num', models.PositiveIntegerField(db_index=True)),
                ('coord_x', models.IntegerField(null=True)),
                ('coord_y', models.IntegerField(null=True)),
                ('floor', models.ForeignKey(verbose_name='этаж', to='django_intranet_stuff.Floor')),
                ('room', models.ForeignKey(verbose_name='комната', blank=True, null=True, to='django_intranet_stuff.Room')),
            ],
            options={
                'db_table': 'intranet_table',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TableBook',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('description', models.CharField(max_length=255, default='')),
                ('date_from', models.DateField()),
                ('date_to', models.DateField()),
                ('staff', models.ForeignKey(related_name='table_book', to='django_intranet_stuff.Staff')),
                ('table', models.ForeignKey(related_name='table_book', to='django_intranet_stuff.Table')),
            ],
            options={
                'db_table': 'intranet_table_book',
            },
        ),
        migrations.CreateModel(
            name='TableReserve',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('native_lang', models.CharField(max_length=2, blank=True, default='')),
                ('intranet_status', models.IntegerField(default=1)),
                ('created_at', models.DateTimeField(editable=False)),
                ('modified_at', models.DateTimeField(editable=False)),
                ('description', models.CharField(max_length=255, default='')),
                ('occupied_at', models.DateField(null=True)),
                ('department', models.ForeignKey(null=True, related_name='table_reserve', to='django_intranet_stuff.Department')),
                ('staff', models.ForeignKey(null=True, related_name='table_reserve', to='django_intranet_stuff.Staff')),
                ('table', models.ForeignKey(related_name='table_reserve', to='django_intranet_stuff.Table')),
            ],
            options={
                'db_table': 'intranet_table_reserve',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VerifyCode',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('object_type', models.CharField(max_length=16, null=True, default='staff', choices=[('staff', 'staff'), ('offer', 'offer'), ('preprofile', 'preprofile')])),
                ('object_id', models.IntegerField(null=True)),
                ('phone_number', models.CharField(max_length=255, null=True)),
                ('code', models.CharField(max_length=20)),
                ('state', models.CharField(max_length=10, default='wait', choices=[('wait', 'wait'), ('verified', 'verified'), ('failed', 'failed'), ('confirmed', 'confirmed')])),
                ('tries', models.IntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('person', models.ForeignKey(blank=True, null=True, related_name='codes', to='django_intranet_stuff.Staff')),
                ('phone', models.ForeignKey(blank=True, null=True, related_name='codes', to='django_intranet_stuff.StaffPhone')),
            ],
            options={
                'db_table': 'intranet_verify_code',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DepartmentResponsible',
            fields=[
                ('departmentstaff_ptr', models.OneToOneField(primary_key=True, serialize=False, auto_created=True, parent_link=True, to='django_intranet_stuff.DepartmentStaff')),
            ],
            options={
                'db_table': 'intranet_departmentresponsible',
            },
            bases=('django_intranet_stuff.departmentstaff',),
        ),
        migrations.AddField(
            model_name='staff',
            name='table',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='django_intranet_stuff.Table'),
        ),
    ]
