# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('django_intranet_stuff', '0001_initial'),
        ('departments', '0002_auto_20211007_1807'),
        ('auth', '0006_require_contenttypes_0002'),
    ]

    operations = [
        migrations.AddField(
            model_name='staff',
            name='user',
            field=models.OneToOneField(null=True, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='room',
            name='floor',
            field=models.ForeignKey(to='django_intranet_stuff.Floor'),
        ),
        migrations.AddField(
            model_name='organization',
            name='city',
            field=models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.City'),
        ),
        migrations.AddField(
            model_name='office',
            name='city',
            field=models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.City'),
        ),
        migrations.AddField(
            model_name='memorialprofile',
            name='person',
            field=models.OneToOneField(verbose_name='Сотрудник', related_name='memorial_profile', to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='groupresponsible',
            name='group',
            field=models.ForeignKey(to='django_intranet_stuff.Group'),
        ),
        migrations.AddField(
            model_name='groupresponsible',
            name='staff',
            field=models.ForeignKey(to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='groupmembership',
            name='group',
            field=models.ForeignKey(to='django_intranet_stuff.Group'),
        ),
        migrations.AddField(
            model_name='groupmembership',
            name='staff',
            field=models.ForeignKey(to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='group',
            name='department',
            field=models.OneToOneField(blank=True, null=True, to='django_intranet_stuff.Department'),
        ),
        migrations.AddField(
            model_name='group',
            name='members',
            field=models.ManyToManyField(related_name='in_groups', to='django_intranet_stuff.Staff', through='django_intranet_stuff.GroupMembership'),
        ),
        migrations.AddField(
            model_name='group',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, related_name='children', to='django_intranet_stuff.Group'),
        ),
        migrations.AddField(
            model_name='group',
            name='permissions',
            field=models.ManyToManyField(blank=True, related_name='groups', to='auth.Permission'),
        ),
        migrations.AddField(
            model_name='group',
            name='responsible',
            field=models.ManyToManyField(related_name='responsible_for_groups', to='django_intranet_stuff.Staff', through='django_intranet_stuff.GroupResponsible'),
        ),
        migrations.AddField(
            model_name='floor',
            name='office',
            field=models.ForeignKey(to='django_intranet_stuff.Office'),
        ),
        migrations.AddField(
            model_name='device',
            name='floor',
            field=models.ForeignKey(to='django_intranet_stuff.Floor'),
        ),
        migrations.AddField(
            model_name='departmentstaffcounter',
            name='department',
            field=models.ForeignKey(to='django_intranet_stuff.Department'),
        ),
        migrations.AddField(
            model_name='departmentstaff',
            name='department',
            field=models.ForeignKey(null=True, to='django_intranet_stuff.Department'),
        ),
        migrations.AddField(
            model_name='departmentstaff',
            name='role',
            field=models.ForeignKey(to='departments.DepartmentRole'),
        ),
        migrations.AddField(
            model_name='departmentstaff',
            name='staff',
            field=models.ForeignKey(null=True, to='django_intranet_stuff.Staff'),
        ),
        migrations.AddField(
            model_name='department',
            name='kind',
            field=models.ForeignKey(null=True, to='django_intranet_stuff.DepartmentKind'),
        ),
        migrations.AddField(
            model_name='department',
            name='parent',
            field=models.ForeignKey(blank=True, null=True, related_name='children', to='django_intranet_stuff.Department'),
        ),
        migrations.AddField(
            model_name='department',
            name='section_caption',
            field=models.ForeignKey(blank=True, null=True, help_text='Подразделение объединено под заголовок', related_name='+', on_delete=django.db.models.deletion.SET_NULL, to='departments.DepartmentInterfaceSection'),
        ),
        migrations.AddField(
            model_name='department',
            name='section_group',
            field=models.ForeignKey(blank=True, null=True, help_text='Подразделение объединено в безымянную группу', related_name='+', on_delete=django.db.models.deletion.SET_NULL, to='departments.DepartmentInterfaceSection'),
        ),
        migrations.AddField(
            model_name='city',
            name='country',
            field=models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.Country'),
        ),
        migrations.CreateModel(
            name='ProxyStaff',
            fields=[
            ],
            options={
                'permissions': (('can_add_wiki_group', 'Can add wiki group'), ('can_edit_wiki_group', 'Can edit wiki group'), ('can_delete_wiki_group', 'Can delete wiki group'), ('can_view_vacation', 'Can view vacation'), ('can_view_paid_day_off', 'Can view paid day off'), ('can_view_meals_sum', 'Can view meals sum'), ('can_edit_work_phone', 'Can edit work phone'), ('can_view_emergency_phone', 'Can view emergency phone'), ('can_view_digital_sign', 'Can view digital sign phone'), ('can_edit_anketa', 'Can edit anketa'), ('can_set_big_boss', 'Can set big boss'), ('can_edit_department', 'Can edit department'), ('can_watch_department_proposals', 'Can watch department proposals list'), ('can_manage_department_proposals', 'Can manage department proposals'), ('can_execute_department_proposals', 'Can execute department proposals'), ('can_edit_official', 'Can edit official'), ('can_edit_head', 'Can edit head'), ('can_edit_location', 'Can edit location'), ('can_edit_keys', 'Can edit keys'), ('can_edit_join_at', 'Can edit join at date'), ('can_withdraw_keys', 'Can withdraw public keys'), ('can_see_keys_audit', 'Can see keys audit'), ('can_upload_photo', 'Can upload photo'), ('can_delete_all_photos', 'Can delete all photos'), ('kill_and_rob', 'Open department admin page'), ('can_view_upravlyator_link', 'Can view upravlyator link'), ('can_view_cabinet_link', 'Can view cabinet link'), ('can_view_password_block', 'Can view password block'), ('can_edit_celery_task', 'Can edit Celery tasks'), ('can_view_trip', 'Can view trip'), ('can_edit_trip', 'Can edit trip'), ('can_send_spam', 'Can send spam'), ('can_mass_give_achievements', 'Can mass give achievements'), ('can_view_permissions', 'Can view permissions'), ('can_view_structure_report', 'Can generate structure report'), ('can_view_staff_report', 'Can generate staff report'), ('can_view_persons_report', 'Can generate persons report'), ('can_view_lenta_report', 'Can generate lenta report'), ('can_view_headcount_report', 'Can generate headcount report'), ('can_view_dismissal_report', 'Can generate dismissal report'), ('can_view_oebs_unlinked_departments_report', 'Can generate oebs unlinked departments report'), ('can_view_staff_ethic_report', 'Can view report for ethic courses'), ('can_view_oebs_unlinked_employees_report', 'Can generate oebs unlinked employees report'), ('can_view_oebs_filred_employees_report', 'Can generate oebs fired employees report'), ('can_view_oebs_chiefs_report', 'Can generate oebs chiefs report'), ('can_view_oebs_department_parents_report', 'Can generate oebs department parents report'), ('can_view_trip_history', 'Can view trip history of any person'), ('can_view_anketa_wish_form_button', 'Can view anketa Wish Form button'), ('can_manage_external_logins', 'Can manage external logins'), ('can_manage_ssh_key_for_externals', 'Can manage ssh keys for external subordinates'), ('can_manage_gaps', 'Can manage gaps'), ('can_view_gaps_with_countries', 'Can view gaps with countries'), ('can_upload_any_ssh_key', 'Can upload any SSH key'), ('can_view_security_devices', 'Can view security devices on map'), ('can_add_security_devices', 'Can add security devices on map'), ('can_view_dismissed_official_base', 'Can view join_at and other on dismissed profile'), ('can_view_quit_at', 'Can view quit_at on profile'), ('can_view_gap_as_external', 'Can view gap (for external users only)'), ('can_view_contacts_as_external', 'Can view contacts (for external users only)'), ('can_use_handle_loan_available', 'Can use handle for loan availability'), ('robot_review_permission', 'Permission for robot-review'), ('can_change_staff', 'Can use handle change_staff'), ('robot_can_update_services', 'Robot ABC can update service')),
                'abstract': False,
                'proxy': True,
            },
            bases=('django_intranet_stuff.staff',),
        ),
        migrations.AlterUniqueTogether(
            name='groupresponsible',
            unique_together=set([('staff', 'group')]),
        ),
        migrations.AlterUniqueTogether(
            name='groupmembership',
            unique_together=set([('staff', 'group')]),
        ),
        migrations.AlterUniqueTogether(
            name='group',
            unique_together=set([('parent', 'role_scope_id')]),
        ),
        migrations.AlterIndexTogether(
            name='group',
            index_together=set([('tree_id', 'lft', 'rght')]),
        ),
        migrations.AlterUniqueTogether(
            name='departmentstaffcounter',
            unique_together=set([('department', 'day')]),
        ),
        migrations.AddField(
            model_name='departmentresponsible',
            name='responsible_for',
            field=models.ForeignKey(related_name='responsibles', to='django_intranet_stuff.Department'),
        ),
    ]
