class RpcException(Exception):
    def __init__(self, error):
        Exception.__init__(self)
        self.error = error


class PermissionDenied(RpcException):
    pass


class RpcRequest:
    def __init__(self, method, params, id=None):
        self.method = method
        self.params = params
        self.id = id


class RpcResponse:
    def __init__(self, result=None, error=None, id=None):
        self.result = result
        self.error = error
        self.id = id
