import json
from staff.django_rpc import RpcRequest

encoder = json.JSONEncoder()
decoder = json.JSONDecoder()


def serialize(response, request):
    if response.error:
        if getattr(response.error, 'error', None):
            response.error = response.error.error
        else:
            response.error = str(response.error)
    return {
        'response': '%s(%s)' % (
            request.GET.get('callback', '$'), encoder.encode(response.__dict__)),
        'mime': 'application/jsonp',
    }


def deserialize(request):
    data = decoder.decode(request.GET.get('json', {}))
    return RpcRequest(
        method=data.get('method', None),
        params=data.get('params', None),
        id=data.get('id', None),
    )
