from django.contrib import admin
from django import forms

from staff.person.models import Staff

from .models import EmailRedirection


def _get_person(login):
    try:
        return Staff.objects.get(login=login)
    except Staff.DoesNotExist:
        raise forms.ValidationError('No person with login `%s`' % login)


class EmailRedirectionAdminForm(forms.ModelForm):
    from_person = forms.CharField()
    to_person = forms.CharField()

    class Meta:
        fields = '__all__'
        model = EmailRedirection

    def clean_from_person(self):
        return _get_person(self.cleaned_data['from_person'])

    def clean_to_person(self):
        return _get_person(self.cleaned_data['to_person'])


class EmailRedirectionAdmin(admin.ModelAdmin):
    list_display = (lambda r: r, 'from_person', 'to_person')
    search_fields = ('from_person__first_name',
                     'from_person__first_name_en',
                     'from_person__last_name',
                     'from_person__last_name_en',
                     'from_person__login',
                     'to_person__first_name',
                     'to_person__first_name_en',
                     'to_person__last_name',
                     'to_person__last_name_en',
                     'to_person__login',)
    form = EmailRedirectionAdminForm


admin.site.register(EmailRedirection, EmailRedirectionAdmin)
