from staff.person.models import Staff as Person

from staff.lib.sync_tools.datagenerators import DataGenerator

from .models import Email


class EmailDataGenerator(DataGenerator):
    sync_fields = ('email', 'person__uid', 'source_type')
    diff_fields = ('email', 'is_main')

    def set_related_object(self, obj, data):
        obj.person = Person.objects.get(uid=data['person__uid'])

    def ext_data_gen(self):
        return self.external_datasource.load_emails()


class CRMEmailDataGenerator(EmailDataGenerator):
    queryset = Email.crm.all()


class PassportEmailDataGenerator(EmailDataGenerator):
    queryset = Email.passport.all()


class StaffEmailDataGenerator(EmailDataGenerator):
    queryset = Email.staff.all()
