from django.db import models

from .source_type import SOURCE_TYPE


class EmailManager(models.Manager):

    def get_queryset(self):
        return (
            super(EmailManager, self)
            .get_queryset()
            .filter(source_type=self.filter_type)
        )


class CRMManager(EmailManager):
    filter_type = SOURCE_TYPE.CRM


class PassportManager(EmailManager):
    filter_type = SOURCE_TYPE.PASSPORT


class StaffManager(EmailManager):
    filter_type = SOURCE_TYPE.STAFF
