# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Email',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('email', models.EmailField(max_length=254)),
                ('source_type', models.CharField(max_length=255, choices=[('crm', 'crm'), ('passport', 'passport'), ('staff', 'staff')])),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_main', models.BooleanField(default=False)),
                ('person', models.ForeignKey(to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.CreateModel(
            name='EmailRedirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('from_person', models.ForeignKey(related_name='emailredirections_from', to='django_intranet_stuff.Staff')),
                ('to_person', models.ForeignKey(related_name='emailredirections_to', to='django_intranet_stuff.Staff')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='email',
            unique_together=set([('person', 'email', 'source_type')]),
        ),
    ]
