from django.db import models

from staff.lib.models.base import AtomicSaveModel

from .managers import CRMManager, PassportManager, StaffManager
from .source_type import SOURCE_TYPE


class Email(AtomicSaveModel):

    person = models.ForeignKey('django_intranet_stuff.Staff')
    email = models.EmailField()
    source_type = models.CharField(max_length=255,
                                   choices=SOURCE_TYPE.choices())
    updated_at = models.DateTimeField(auto_now=True)
    is_main = models.BooleanField(default=False)

    objects = models.Manager()
    crm = CRMManager()
    passport = PassportManager()
    staff = StaffManager()

    class Meta:
        unique_together = ('person', 'email', 'source_type')

    def __str__(self):
        return '{email}'.format(**vars(self))


class EmailRedirection(models.Model):
    from_person = models.ForeignKey('django_intranet_stuff.Staff',
                                    related_name='emailredirections_from')
    to_person = models.ForeignKey('django_intranet_stuff.Staff',
                                  related_name='emailredirections_to')

    def __str__(self):
        return '{from_person.login} -> {to_person.login}'.format(
            from_person=self.from_person,
            to_person=self.to_person)
