from django.http import HttpResponse

from staff.lib.decorators import auth_by_tvm_only

from .controllers import EmailRedirectionController


@auth_by_tvm_only(['ml'])
def redirections_list(request, format_):
    ctrl = EmailRedirectionController()
    method = getattr(ctrl, 'get_%s' % format_)
    content_type = {
        'xml': 'text/xml',
        'json': 'application/json',
    }[format_]
    return HttpResponse(method(), content_type=content_type)
