from django_pgaas.backend.base import DatabaseWrapper


class EmissionDatabaseWrapper(DatabaseWrapper):

    @staticmethod
    def _get_controller():
        from .controller import controller
        return controller

    def commit(self):
        self._get_controller().commit()
        return super().commit()

    def rollback(self):
        self._get_controller().reset_context()
        return super().rollback()

    def close(self):
        self._get_controller().reset_context()
        return super().close()

    def savepoint_rollback(self, sid):
        self._get_controller().reset_context(sid=sid)
        return super().savepoint_rollback(sid=sid)
