from django import forms

from . import settings


MODELS = [name.lower() for name in settings.REPLICATED_MODELS]


class SliceForm(forms.Form):
    start = forms.IntegerField()
    stop = forms.IntegerField(required=False)
    multipart = forms.BooleanField(required=False)


class EntityForm(forms.Form):
    name = forms.ChoiceField(choices=zip(MODELS, MODELS))
    multipart = forms.BooleanField(required=False)
    continuation_token = forms.CharField(required=False)


class MetaForm(forms.Form):
    current = forms.IntegerField(required=False)


class GetUnsentForm(forms.Form):
    count = forms.IntegerField(min_value=1, max_value=10000, required=False)
