# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import staff.emission.django.emission_master.utils


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='MasterLog',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('data', models.TextField()),
                ('creation_time', models.CharField(max_length=32, db_index=True, default=staff.emission.django.emission_master.utils.now_str)),
                ('action', models.CharField(max_length=10, default='modify', choices=[('modify', 'modify'), ('delete', 'delete')])),
                ('batch_id', models.UUIDField(blank=True, null=True, db_index=True)),
            ],
            options={
                'verbose_name': 'Incremental log for model changes',
                'verbose_name_plural': 'Incremental log for model changes',
            },
        ),
        migrations.CreateModel(
            name='NotSent',
            fields=[
                ('entry', models.ForeignKey(primary_key=True, unique=True, serialize=False, to='emission_master.MasterLog')),
            ],
        ),
        migrations.CreateModel(
            name='Sent',
            fields=[
                ('entry', models.ForeignKey(primary_key=True, unique=True, serialize=False, to='emission_master.MasterLog')),
            ],
        ),
    ]
