import kikimr.public.sdk.python.persqueue.grpc_pq_streaming_api as pqlib
import kikimr.public.sdk.python.persqueue.auth as auth

from staff.lib.tvm2 import get_tvm_client

from django.conf import settings


class LogbrokerClient:
    def __init__(self, tvm_client):
        credentials_provider = auth.TVMCredentialsProvider(tvm_client=tvm_client, destination_client_id='2001059')
        self.credentials_provider = credentials_provider
        self.endpoint = settings.LOG_BROKER_ENDPOINTS[0]
        self.port = settings.LOG_BROKER_PORT
        self.api = pqlib.PQStreamingAPI(self.endpoint, self.port)
        api_start_future = self.api.start()
        api_start_future.result(timeout=10)

    def get_producer(self, producer_name, topic_name):
        configurator = pqlib.ProducerConfigurator(topic_name, producer_name.encode())
        producer = self.api.create_producer(configurator, credentials_provider=self.credentials_provider)
        return producer

    def get_consumer(self, consumer_name, topic_name):
        configurator = pqlib.ConsumerConfigurator(topic_name, client_id=consumer_name.encode())
        consumer = self.api.create_consumer(configurator, credentials_provider=self.credentials_provider)
        return consumer


def get_logbroker_client() -> LogbrokerClient:
    tvm_client = get_tvm_client()
    return LogbrokerClient(tvm_client)
