import concurrent.futures
import logging
import json

from django.conf import settings
from django.utils.functional import SimpleLazyObject

from staff.celery_app import app
from staff.emission.logbroker.controller import controller
from staff.emission.logbroker.client import get_logbroker_client


logger = logging.getLogger(__name__)

client = SimpleLazyObject(lambda: get_logbroker_client())


@app.task
def load_to_logbroker():
    data = controller.get_unsent(settings.LOG_BROKER_CHUNK_SIZE)
    producer = client.get_producer(settings.LOG_BROKER_PRODUCER_NAME, settings.LOG_BROKER_MODEL_TOPIC)
    start_future = producer.start()
    try:
        start_result = start_future.result(timeout=10)

        if hasattr(start_result, 'init'):
            max_seq_no = start_result.init.max_seq_no

            for item in data:
                max_seq_no += 1
                response = producer.write(max_seq_no, json.dumps(item).encode())
                write_result = response.result(timeout=10)

                if hasattr(write_result, 'ack'):
                    controller.mark_sent([item['id']])
                else:
                    logger.warning('Message write failed with error %s', write_result)
        else:
            logger.warning('Producer failed to start with error %s', start_result)
    except concurrent.futures.TimeoutError:
        logger.info('Log broker timeout', exc_info=True)
