from django.contrib import admin

from staff.femida.models import FemidaVacancy


class FemidaVacancyAdmin(admin.ModelAdmin):
    list_display = (
        'id',
        'name',
        'created',
        'modified',
        'offer_id',
        'candidate_first_name',
        'candidate_last_name',
    )
    search_fields = (
        'id',
        'offer_id',
        'preprofile_id',
        'headcount_position_id',
    )


admin.site.register(FemidaVacancy, FemidaVacancyAdmin)
