# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.contrib.postgres.fields


class Migration(migrations.Migration):

    dependencies = [
        ('departments', '0002_auto_20211007_1807'),
    ]

    operations = [
        migrations.CreateModel(
            name='FemidaVacancy',
            fields=[
                ('id', models.IntegerField(verbose_name='ID вакансии', primary_key=True, serialize=False)),
                ('name', models.CharField(verbose_name='Наименование вакансии', max_length=255, default='')),
                ('created', models.DateTimeField(verbose_name='Дата создания')),
                ('modified', models.DateTimeField(verbose_name='Дата изменения')),
                ('startrek_key', models.CharField(verbose_name='JOB тикет', max_length=32, null=True)),
                ('startrek_salary_key', models.CharField(verbose_name='SALARY тикет при ротации', max_length=32, null=True)),
                ('offer_id', models.IntegerField(verbose_name='ID оффера', null=True)),
                ('candidate_first_name', models.CharField(verbose_name='имя кандидата', max_length=255, blank=True)),
                ('candidate_last_name', models.CharField(verbose_name='фамилия кандидата', max_length=255, blank=True)),
                ('candidate_login', models.CharField(verbose_name='логин кандидата', max_length=64, blank=True)),
                ('candidate_id', models.IntegerField(verbose_name='ID кандидата', null=True)),
                ('preprofile_id', models.IntegerField(verbose_name='ID препрофайла', null=True)),
                ('headcount_position_id', models.IntegerField(verbose_name='ID БП', null=True)),
                ('status', models.CharField(verbose_name='статус вакансии', max_length=64, choices=[('closed', 'closed'), ('draft', 'draft'), ('on_approval', 'on_approval'), ('offer_accepted', 'offer_accepted'), ('suspended', 'suspended'), ('in_progress', 'in_progress'), ('offer_processing', 'offer_processing')])),
                ('application_id', models.IntegerField(verbose_name='application ID', null=True)),
                ('is_published', models.BooleanField(verbose_name='Внутреннее объявление опубликовано')),
                ('is_hidden', models.BooleanField(verbose_name='Вакансия скрыта', default=False)),
                ('profession_staff_id', models.CharField(verbose_name='ID профессии из фемиды', max_length=255, null=True)),
                ('department_url', models.CharField(verbose_name='url департамента', max_length=255, null=True)),
                ('members', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=50), size=None)),
                ('staff_vacancy', models.ForeignKey(null=True, related_name='+', to='departments.Vacancy')),
            ],
        ),
    ]
