from django.contrib.postgres.fields import ArrayField
from django.db import models

from staff.departments.models import Vacancy

from staff.femida.constants import VACANCY_STATUS


class FemidaVacancy(models.Model):
    id = models.IntegerField(
        primary_key=True,
        null=False,
        blank=False,
        verbose_name='ID вакансии',
    )

    name = models.CharField(
        blank=False,
        max_length=255,
        default='',
        verbose_name='Наименование вакансии',
    )

    created = models.DateTimeField(
        blank=False,
        verbose_name='Дата создания',
    )

    modified = models.DateTimeField(
        blank=False,
        verbose_name='Дата изменения',
    )

    startrek_key = models.CharField(
        null=True,
        blank=False,
        max_length=32,
        verbose_name='JOB тикет',
    )

    startrek_salary_key = models.CharField(
        null=True,
        blank=False,
        max_length=32,
        verbose_name='SALARY тикет при ротации',
    )

    offer_id = models.IntegerField(
        null=True,
        blank=False,
        verbose_name='ID оффера',
    )

    candidate_first_name = models.CharField(
        max_length=255,
        blank=True,
        verbose_name='имя кандидата',
    )

    candidate_last_name = models.CharField(
        max_length=255,
        blank=True,
        verbose_name='фамилия кандидата',
    )

    candidate_login = models.CharField(
        max_length=64,
        blank=True,
        verbose_name='логин кандидата',
    )

    candidate_id = models.IntegerField(
        null=True,
        blank=False,
        verbose_name='ID кандидата',
    )

    preprofile_id = models.IntegerField(
        null=True,
        blank=False,
        verbose_name='ID препрофайла',
    )

    headcount_position_id = models.IntegerField(
        null=True,
        blank=False,
        verbose_name='ID БП',
    )

    status = models.CharField(
        max_length=64,
        choices=VACANCY_STATUS.choices(),
        blank=False,
        null=False,
        verbose_name='статус вакансии',
    )

    staff_vacancy = models.ForeignKey(
        Vacancy,
        related_name='+',
        null=True,
    )

    application_id = models.IntegerField(
        null=True,
        blank=False,
        verbose_name='application ID',
    )

    is_published = models.BooleanField(
        blank=False,
        null=False,
        verbose_name='Внутреннее объявление опубликовано',
    )

    is_hidden = models.BooleanField(
        blank=False,
        default=False,  # TODO: Remove after sync
        null=False,
        verbose_name='Вакансия скрыта',
    )

    profession_staff_id = models.CharField(
        max_length=255,
        blank=False,
        null=True,
        verbose_name='ID профессии из фемиды',
    )

    department_url = models.CharField(
        max_length=255,
        blank=False,
        null=True,
        verbose_name='url департамента',
    )

    members = ArrayField(models.CharField(max_length=50, blank=False, null=False))
