import logging

from staff.celery_app import app

from staff.lib.sync_tools.updater import Updater, DataDiffMerger
from staff.lib.tasks import LockedTask

from staff.femida.vacancies_datagenerator import VacanciesDataGenerator
from staff.femida.vacancies_datasource import VacanciesDatasource
from staff.femida.vacancies_rolluper import VacanciesRolluper

logger = logging.getLogger(__name__)


@app.task(ignore_result=True)
class SyncVacanciesTask(LockedTask):
    def _create_updater(self) -> Updater:
        data_source = VacanciesDatasource()
        data_generator = VacanciesDataGenerator(data_source)
        data_diff_merger = DataDiffMerger(data_generator)
        updater = Updater(data_diff_merger, logger)
        return updater

    def locked_run(self, **kwargs):
        logger.info('SyncVacanciesTask {0}'.format(locals()))
        self._create_updater().run_sync()


@app.task(ignore_result=True)
class RollupVacanciesTask(LockedTask):
    def locked_run(self, **kwargs):
        logger.info('RollupVacanciesTask {0}'.format(locals()))
        VacanciesRolluper(create_absent=True).run_rollup()


@app.task(ignore_result=True)
class Pull(LockedTask):
    def locked_run(self, *args, **kwargs):
        SyncVacanciesTask()
        RollupVacanciesTask()
