import re
from typing import Optional

import yenv


job_issue_regexp = re.compile(
    '/(JOB-\\d+)$'
    if yenv.type == 'production'
    else '/(TJOB-\\d+)$'
)


class FemidaUtils:

    def get_vacancy_issue_key_from_url(self, vacancy_url: str) -> Optional[str]:
        if not vacancy_url:
            return None
        m = job_issue_regexp.search(vacancy_url)
        return m and m.group(1) or None


def get_vacancy_issue_key_from_url(vacancy_url: str) -> Optional[str]:
    return FemidaUtils().get_vacancy_issue_key_from_url(vacancy_url)
