from staff.lib import waffle
from waffle.models import Switch

from django.views.decorators.http import require_http_methods

from staff.lib.decorators import responding_json


@responding_json
@require_http_methods(['GET'])
def switch(request, switch_name):
    return {
        'active': waffle.switch_is_active(switch_name)
    }


@responding_json
@require_http_methods(['GET'])
def switches(request):
    return list(Switch.objects.values('name', 'active'))
