from django.contrib import admin

from staff.lib.utils.admin import StaffModelAdmin
from staff.gap.models import Gap, Workflow, GapTasksQueue


class WorkflowAdmin(StaffModelAdmin):
    list_display = ('name', 'verbose_name', 'color', 'rank')
    ordering = ('name', )


class GapAdmin(StaffModelAdmin):
    list_display = ('staff', 'gap_type', 'left_edge', 'right_edge', 'created_by', 'state')
    list_filter = ('gap_type', 'state')
    ordering = ('-left_edge', '-right_edge')


class GapTasksQueueAdmin(StaffModelAdmin):
    list_display = ('id', 'gap_id', 'module', 'callable', 'fail_count', 'args')
    ordering = ('gap_id', 'id')


admin.site.register(Gap, GapAdmin)
admin.site.register(Workflow, WorkflowAdmin)
admin.site.register(GapTasksQueue, GapTasksQueueAdmin)
