from staff.gap.controllers.gap import GapCtl


STAFF_DATE_FORMAT = '%d.%m.%Y'
DEFAULT_ENCODING = 'windows-1251'


EXPORT_FIELDS = {
    'id': 1,
    'gap_type': 1,
    'state': 1,
    'modified_at': 1,
    'person_login': 1,
    'person_id': 1,
    'date_from': 1,
    'date_to': 1,
    'comment': 1,
}


# постраничность
def export_gap(gap_type=None, modified_from=None, modified_to=None,
               date_from=None, date_to=None,
               login_list=None, state_list=None):
    query = []

    if gap_type is not None:
        query.append({'gap_type': gap_type})

    if modified_from is not None:
        query.append({'modified_at': {'$gte': modified_from}})

    if modified_to is not None:
        query.append({'modified_at': {'$lte': modified_to}})

    if date_from is not None:
        query.append({'date_from': {'$gte': date_from}})

    if date_to is not None:
        query.append({'date_to': {'$lte': date_to}})

    if login_list:
        query.append({'person_login': {'$in': login_list}})

    if state_list:
        query.append({'person_login': {'$in': login_list}})

    query.append({'$or': [
        {'is_private': {'$exists': False}},
        {'is_private': False},
    ]})

    return GapCtl().find_gaps({'$and': query}, EXPORT_FIELDS)
