from django.core.exceptions import ValidationError


class ImportMandatoryVacationsError(ValidationError):
    pass


class NonUniqueLoginsError(ImportMandatoryVacationsError):

    def __init__(self, login: str):
        super().__init__(
            'Logins must be unique',
            code='non-unique-login',
            params={
                'login': login,
            },
        )


class NoLoginColumnError(ImportMandatoryVacationsError):

    def __init__(self):
        super().__init__(
            'Missing the login column',
            code='missing-login-column',
        )


class NoDateFromColumn(ImportMandatoryVacationsError):

    def __init__(self, login: str):
        super().__init__(
            'Missing date_from column',
            code='missing-date_from-column',
            params={
                'login': login,
            },
        )


class WrongDateFormat(ImportMandatoryVacationsError):

    def __init__(self, login: str):
        super().__init__(
            'Wrong date format',
            code='wrong-date-format',
            params={
                'login': login,
            },
        )


class NonexistentLogin(ImportMandatoryVacationsError):

    def __init__(self, login: str):
        super().__init__(
            'Nonexistent login',
            code='nonexistent-login',
            params={
                'login': login,
            },
        )


class AlreadyHasMandatoryVacationError(ImportMandatoryVacationsError):

    def __init__(self, login: str, gap_id: int):
        super().__init__(
            'Person already has mandatory vacation this year',
            code='already-has-mandatory-vacation-this-year',
            params={
                'login': login,
                'gap_id': gap_id,
            },
        )


class NoGapWithThisIssueKeyError(Exception):
    pass
