from django.conf.urls import url

from staff.gap.api import views

urlpatterns = [
    url(
        r'^gap_cancel/(?P<gap_id>\d+)/?$',
        views.gap_state_views.gap_cancel,
        name='api-gap-cancel',
    ),
    url(
        r'^gap_confirm/(?P<gap_id>\d+)/?$',
        views.gap_state_views.gap_confirm,
        name='api-gap-confirm',
    ),
    url(
        r'^gap_confirm_by_issue/(?P<issue_key>[A-Z]+-\d+)/?$',
        views.gap_state_views.gap_confirm_by_issue,
        name='api-gap-confirm-by-issue',
    ),
    url(
        r'^gap_create/?$',
        views.gap_change_views.gap_create,
        name='api-gap-create',
    ),
    url(
        r'^gap_edit/?$',
        views.gap_change_views.gap_edit,
        name='api-gap-edit',
    ),
    url(
        r'^gap_find/(?P<gap_id>\d+)/?$',
        views.gap_find_views.gap_find,
        name='api-gap-find',
    ),
    url(
        r'^gap_sign/(?P<gap_id>\d+)/?$',
        views.gap_state_views.gap_sign,
        name='api-gap-sign',
    ),
    url(
        r'^gaps_find/?$',
        views.gap_find_views.gaps_find,
        name='api-gaps-find',
    ),
    url(
        r'^workflows/?$',
        views.workflow_views.workflows,
        name='api-workflows',
    ),
    url(
        r'^availability/?$',
        views.availability_views.availability,
        name='api-availability',
    ),
    url(
        r'^export_gaps/?$',
        views.gaps_export_views.export_gaps_json,
        name='api-export-gaps-default',
    ),
    url(
        r'^export_gaps\.json/?$',
        views.gaps_export_views.export_gaps_json,
        name='api-export-gaps-json',
    ),
    url(
        r'^haction/(?P<haction_hash>[a-zA-Z0-9]+)/?$',
        views.hashed_action_views.haction,
        name='api-haction',
    ),
    url(
        r'^haction/(?P<haction_hash>[a-zA-Z0-9]+)/(?P<gap_id>\d+)/?$',
        views.hashed_action_views.haction,
        name='api-haction',
    ),
    url(
        r'^need_for_attention/?$',
        views.need_for_attention_views.need_for_attention,
        name='api-need-for-attention',
    ),
    url(
        r'^readable_gaps/?$',
        views.readable_gaps_views.readable_gaps,
        name='api-readable-gaps',
    ),
    url(
        r'^need_update_gap/(?P<service_id>\d+)/?$',
        views.update_gap.need_update_gap,
        name='api-need-update-gap',
    ),
    url(
        r'^import_mandatory_vacations/?$',
        views.import_mandatory_vacations.import_mandatory_vacations,
        name='api-import-mandatory-vacations',
    ),
]
